﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using AZVIC.Ei8htPOS.POSRetail.Constants;
using AZVIC.Ei8htPOS.Entities;
using AZVIC.Ei8htPOS.BAL;
using System.Windows.Threading;
using System.Threading;
using AZVIC.Ei8htPOS.Utilities;
using AZVIC.Ei8htPOS.POSRetail.Controls.Loading;
using AZVIC.Ei8htPOS.POSRetail;
using AZVIC.Ei8htPOS.POSRetail.Controls;
using AZVIC.Ei8htPOS.POSRetail.Helpers;

namespace AZVIC.Ei8htPOS.POSRetail.Pages
{
    /// <summary>
    /// Interaction logic for Ordering.xaml
    /// </summary>
    public partial class Ordering : Page
    {
        private MasterWindow Master { get; set; }

        private bool GstApplied;

        public Ordering()
        {
            InitializeComponent();

            //if (!AppSession.CurrentAdminUser.UserRoleType.ToLower().Equals("superadmin"))
            //{
            //btnChangePrice.IsEnabled = false;
            //}

            Master = (Application.Current.MainWindow as MasterWindow);
            GstApplied = AppSession.ApplyGST;

            LoadMenu();
            LoadProducts(string.Empty);
            LoadCategory();
            BindShoppingCart();

            Master.ShowHideCopyrightInfo(true);
            Master.UpdateCustomerName();
            PoleDisplayHelper.ClearDisplay();
        }

        #region Member Function
        private void LoadProducts(string searchKeyword)
        {
            List<Products> Products = new List<Entities.Products>();
            ProgressDialogResult result = ProgressDialog.Execute(Application.Current.MainWindow, string.Empty, fun =>
             icProductList.Dispatcher.BeginInvoke(new Action(() =>
                 icProductList.ItemsSource = (from p in AppSession.ProductsList
                                              where (searchKeyword == string.Empty || (p.ProductName.ToLower().Contains(searchKeyword.ToLower()) ||
                                                                                       p.ProductDescriptions.ToLower().Contains(searchKeyword.ToLower()) ||
                                                                                       p.ProductCode.ToLower().Contains(searchKeyword.ToLower()) ||
                                                                                       p.AdditionalInfo.ToLower().Contains(searchKeyword.ToLower()) ||
                                                                                       p.ProductCategoryID.ToString().ToLower().Contains(searchKeyword.ToLower()) ||
                                                                                       p.UnitPrice.ToString().ToLower().Contains(searchKeyword.ToLower())))
                                              group p by p.ProductName into g
                                              select g.First()).OrderBy(a => a.SequenceNo).ToList<Products>())));


        }

        private void LoadCategory()
        {
            icCategoryList.ItemsSource = AppSession.CategoryList;
        }

        private void BindShoppingCart()
        {
            if (AppSession.CurrentOrders == null)
            {
                AppSession.CurrentOrders = new Orders();
                AppSession.CurrentOrders.Mode = GlobalConfigurations.Mode.Insert;
            }

            lstShoppingCart.ItemsSource = null;
            lstShoppingCart.ItemsSource = AppSession.CurrentOrders.OrdersDetailsList;

            AppSession.CurrentOrders.SubTotal = (from co in AppSession.CurrentOrders.OrdersDetailsList
                                                 select co).Sum(r => r.Amount);

            if (!AppSession.CurrentOrders.OrdersDetailsList.Any())
            {
                AppSession.CurrentOrders.HappyHoursDiscount = AppSession.CurrentOrders.TotalDiscount = 0.00M;
            }

            decimal discount = 0, happyhourdiscount = 0;
            foreach (OrdersDetails od in AppSession.CurrentOrders.OrdersDetailsList)
            {
                if (AppSession.IsHappyHour)
                {
                    Products currentProduct = AppSession.ProductsList.Where(a => a.UniqueID == od.ProductID).Select(a => a).Single();
                    happyhourdiscount += currentProduct.HappyHourPrice != 0.00M ? od.Quantity * (currentProduct.UnitPrice - currentProduct.HappyHourPrice) : 0.00M;
                }
                if (od.DiscountType.Trim().ToLower().Equals("dollar"))
                {
                    discount += (od.Quantity * od.DiscountValue);
                }
                else if (od.DiscountType.Trim().ToLower().Equals("percentage"))
                {
                    discount += (od.Quantity * (od.OrderPrice * od.DiscountValue / 100));
                }
            }
            AppSession.CurrentOrders.HappyHoursDiscount = happyhourdiscount;
            AppSession.CurrentOrders.Discount = discount;

            ApplyTxnDiscount();
            //ApplyServiceTax();

            AppSession.CurrentOrders.TotalBeforeGST = ((AppSession.CurrentOrders.SubTotal - AppSession.CurrentOrders.HappyHoursDiscount - AppSession.CurrentOrders.TotalDiscount - AppSession.CurrentOrders.Discount) + AppSession.CurrentOrders.ServiceTax);

            if (GstApplied)
            {
                ApplyGST(false);
                btnApplyGST.Visibility = System.Windows.Visibility.Hidden;
                btnRemoveGST.Visibility = System.Windows.Visibility.Visible;
            }
            else
            {
                ApplyGST(true);
                btnApplyGST.Visibility = System.Windows.Visibility.Visible;
                btnRemoveGST.Visibility = System.Windows.Visibility.Hidden;
            }

            decimal totalBeforeRound = AppSession.CurrentOrders.TotalBeforeGST + AppSession.CurrentOrders.GST;
            AppSession.CurrentOrders.Total = AppSession.ApplyRoundTotal ? AppSession.RoundAmount(totalBeforeRound) : totalBeforeRound;
            AppSession.CurrentOrders.RoundedAmount = AppSession.CurrentOrders.Total - totalBeforeRound;

            ApplyPromotion();

            lblTableName.Text = "Table #: " + AppSession.CurrentOrders.TableNumber;
            lblSubTotal.Text = AppSession.CurrentOrders.SubTotal.ToString("$ 0.00");
            lblDiscount.Text = AppSession.CurrentOrders.Discount.ToString("$ 0.00");
            lblTotalDiscount.Text = AppSession.CurrentOrders.TotalDiscount.ToString("$ 0.00");
            lblHappyHoursDiscount.Text = AppSession.CurrentOrders.HappyHoursDiscount.ToString("$ 0.00");
            lblServiceTax.Text = AppSession.CurrentOrders.ServiceTax.ToString("$ 0.00");
            lblTotalBeforeGST.Text = AppSession.CurrentOrders.TotalBeforeGST.ToString("$ 0.00");
            lblGST.Text = AppSession.CurrentOrders.GST.ToString("$ 0.00");
            lblBeforeRounding.Text = totalBeforeRound.ToString("$ 0.00");
            lblRounding.Text = AppSession.CurrentOrders.RoundedAmount.ToString("$ 0.00");
            lblTotal.Text = AppSession.CurrentOrders.Total.ToString("$ 0.00");

            if (!(lstShoppingCart.Items.IsEmpty))
            {
                lstShoppingCart.ScrollIntoView(lstShoppingCart.Items[lstShoppingCart.Items.Count - 1]);
            }
            lstShoppingCart.SelectedIndex = -1;
            txtSearchBox.Focus();
        }

        private void AddMiscellaneousItem()
        {
            Controls.MiscItems miscItem = new Controls.MiscItems();
            miscItem.Owner = Application.Current.MainWindow;
            miscItem.ShowInTaskbar = false;
            miscItem.ShowDialog();
            if (bool.Parse(miscItem.Tag.ToString()))
                BindShoppingCart();
        }

        private void LoadCategory(Guid catID)
        {
            List<Products> FilteredProducts = (from products in AppSession.ProductsList
                                               where ((products.ProductCategoryID == catID) || (products.ProductsXCategoryList.Where(a => a.ProductCategoryID == catID).Any()))
                                               group products by products.ProductName into uniqueproducts
                                               select uniqueproducts.First()).OrderBy(a => a.ProductName).ToList<Products>();
            icProductList.ItemsSource = FilteredProducts;
            //AppSession.CategoryID = catID;
        }

        #endregion

        #region Navigation Helper

        private void LoadMenu()
        {
            Master.LoadMenu(Menus.ORDER);
        }

        #endregion

        #region Private Event Handlers

        private void txtSearchBox_GotFocus(object sender, RoutedEventArgs e)
        {
            txtSearchBox.Text = string.Empty;
        }

        private void txtSearchBox_LostFocus(object sender, RoutedEventArgs e)
        {
            txtSearchBox.Text = txtSearchBox.IsFocused ? string.Empty : UIConstants.SEARCH_DEFAULT;
        }

        private void btnAddToCart_Click(object sender, RoutedEventArgs e)
        {
            PoleDisplayHelper.ClearDisplay();
            AppSession.CurrentOrders = (AppSession.CurrentOrders == null ? new Orders() : AppSession.CurrentOrders);
            AppSession.CurrentOrders.TableNumber = "01";
            //if (string.IsNullOrEmpty(AppSession.CurrentOrders.TableNumber))
            //{
            //    Controls.CustomizeTableLayout pgeConfirm = new Controls.CustomizeTableLayout();
            //    pgeConfirm.Owner = Application.Current.MainWindow;
            //    pgeConfirm.ShowInTaskbar = false;
            //    pgeConfirm.ShowDialog();
            //    if (!bool.Parse(pgeConfirm.Tag.ToString()))
            //        return;
            //}
            Button btnAddToCart = sender as Button;
            Guid productID = Guid.Parse(btnAddToCart.Tag.ToString());
            // Check if the item has any other size 
            string ProductName = AppSession.ProductsList.Where(a => a.UniqueID == productID).Select(a => a.ProductName).Single();
            bool MultipleSizes = AppSession.ProductsList.Where(a => a.ProductName == ProductName).Count() > 1;
            if (!MultipleSizes)
            {
                List<ProductsXMeasurements> Measurements = ProductsXMeasurementBL.GetList(Guid.Empty, productID);
                if (Measurements != null && Measurements.Count > 0)
                {
                    Measurements = Measurements.Where(a => a.IsActive).ToList<ProductsXMeasurements>();
                }
                MultipleSizes = (Measurements != null && Measurements.Count > 0) ? true : false;
            }
            string strProductSelected = "";
            Guid ProductSelected = Guid.Empty, DummysizeID = Guid.Empty;
            if (MultipleSizes)
            {
                strProductSelected = SelectSize.Prompt(ProductName, productID);

                if (strProductSelected != null && (!string.IsNullOrEmpty(strProductSelected)))
                {
                    //Is a dummy size
                    if (strProductSelected.IndexOf('|') != -1)
                    {
                        ProductSelected = Guid.Parse(strProductSelected.Substring(0, strProductSelected.IndexOf('|')));
                        DummysizeID = Guid.Parse(strProductSelected.Substring(strProductSelected.IndexOf("|") + 1, strProductSelected.Length - strProductSelected.IndexOf("|") - 1));
                    }
                    else
                    {
                        ProductSelected = Guid.Parse(strProductSelected);
                        DummysizeID = Guid.Empty;
                    }
                }
                else
                {
                    return;
                }

                if (ProductSelected != Guid.Empty)
                    productID = ProductSelected;
                else
                    return;
            }

            Products curProd = ProductsBL.GetItem(productID, string.Empty);

            if (AppSession.CurrentOrders == null)
            {
                AppSession.CurrentOrders = new Orders();
                AppSession.CurrentOrders.Mode = GlobalConfigurations.Mode.Insert;
            }

            if (!curProd.IsMiscellaneous)
            {
                if (DummysizeID != Guid.Empty)
                {
                    ProductsXMeasurements DummySize = ProductsXMeasurementBL.GetItem(DummysizeID, productID);
                    AppSession.AddProductToCart(AppSession.CurrentOrders, curProd, curProd.UnitPrice, string.Empty, 0, 1 * DummySize.TargetConversion, 0, string.Empty, true, false, DummySize.TargetConversion, DummySize.TargetSizeName);
                }
                else
                    AppSession.AddProductToCart(AppSession.CurrentOrders, curProd, curProd.UnitPrice, string.Empty, 0, 1, 0, string.Empty, true, false, 0);
                BindShoppingCart();
                LoadProducts(string.Empty);
            }
            else
                AddMiscellaneousItem();

            OrdersDetails _OrderDetail = AppSession.CurrentOrders.OrdersDetailsList.Where(a => a.ProductID == productID).SingleOrDefault();
            PoleDisplayHelper.DisplayOrderDetails(_OrderDetail);

        }

        private void btnClearCart_Click(object sender, RoutedEventArgs e)
        {
            AppSession.CurrentOrders = new Orders();
            AppSession.CurrentOrders.Mode = GlobalConfigurations.Mode.Insert;
            AppSession.CurrentUser = null;
            GstApplied = AppSession.ApplyGST;
            BindShoppingCart();
            //ShowTableSelection();
            PoleDisplayHelper.ClearDisplay();
        }

        private void btnDelete_Click(object sender, RoutedEventArgs e)
        {
            OrdersDetails selectedItem = lstShoppingCart.SelectedItem as OrdersDetails;
            if (selectedItem == null)
            {
                selectedItem = AppSession.CurrentOrders.OrdersDetailsList.LastOrDefault<OrdersDetails>();
            }
            if (selectedItem != null)
            {
                AppSession.RemoveProductFromCart(AppSession.CurrentOrders, selectedItem);
                BindShoppingCart();
            }
        }

        private void txtSearchBox_KeyUp(object sender, KeyEventArgs e)
        {
            LoadProducts(txtSearchBox.Text.Trim());
        }

        private void btnCheckout_Click(object sender, RoutedEventArgs e)
        {
            //if (AppSession.CurrentOrders == null || AppSession.CurrentOrders.TableNumber == null)
            //{
            //    Controls.CustomizeTableLayout pgeConfirm = new Controls.CustomizeTableLayout();
            //    pgeConfirm.Owner = Application.Current.MainWindow;
            //    pgeConfirm.ShowInTaskbar = false;
            //    pgeConfirm.ShowDialog();
            //    if (!bool.Parse(pgeConfirm.Tag.ToString()))
            //        return;
            //}

            if (AppSession.CurrentOrders != null && AppSession.CurrentOrders.OrdersDetailsList.Count > 0)
            {
                PoleDisplayHelper.DisplayItem("Payment due", " ", string.Format("{0:C}", AppSession.CurrentOrders.Total));
                Controls.OrderConfirmation pgeConfirm = new Controls.OrderConfirmation();
                pgeConfirm.Owner = Application.Current.MainWindow;
                pgeConfirm.ShowInTaskbar = false;
                pgeConfirm.ShowDialog();
                if (bool.Parse(pgeConfirm.Tag.ToString()))
                {
                    GstApplied = AppSession.ApplyGST;
                    BindShoppingCart();
                    //if (string.IsNullOrEmpty(AppSession.CurrentOrders.TableNumber))
                    //{
                    //    ShowTableSelection();
                    //}
                }
            }
            else
            {
                App.ShowErrorMessageBox("Please add any Items to the cart", "Ei8ht POS");
            }
        }

        private void btnQty_Click(object sender, RoutedEventArgs e)
        {
            OrdersDetails selectedItem;
            if (lstShoppingCart.SelectedItem != null)
            {
                selectedItem = lstShoppingCart.SelectedItem as OrdersDetails;
                string NewQty = UserPrompt.Prompt("Please enter the new quantity for " + selectedItem.ProductName, "Quantity Change");
                if (NewQty != null)
                {

                    if (!ValidationUtility.ValidateInt(NewQty))
                    {
                        App.ShowErrorMessageBox("Please enter valid Quantity.", "Ei8ht POS");
                        return;
                    }

                    if (selectedItem == null)
                    {
                        selectedItem = AppSession.CurrentOrders.OrdersDetailsList.LastOrDefault<OrdersDetails>();
                    }
                    if (selectedItem != null)
                    {
                        Products curProduct = null;
                        if (!selectedItem.IsMiscellaneous)
                        {
                            curProduct = (from p in AppSession.ProductsList
                                          where p.UniqueID == selectedItem.ProductID
                                          select p).Single<Products>();
                        }
                        else
                        {
                            curProduct = AppSession.ProductsList.Where(p => p.IsMiscellaneous == true).FirstOrDefault();
                            curProduct.IsMiscellaneous = selectedItem.IsMiscellaneous;
                            curProduct.ProductName = selectedItem.ProductName;
                            curProduct.ProductDescriptions = selectedItem.Remarks;
                            curProduct.UnitPrice = selectedItem.OrderPrice;
                        }
                        OrdersDetails ord = AppSession.CurrentOrders.OrdersDetailsList.Where(a => a.ProductID == selectedItem.ProductID).Single();
                        if (ord.DisplayQuantity == 0)
                            AppSession.AddProductToCart(AppSession.CurrentOrders, curProduct, selectedItem.OrderPrice, selectedItem.DiscountType, selectedItem.DiscountValue, int.Parse(NewQty), 0, string.Empty, false, curProduct.IsMiscellaneous, 0);
                        else
                        {
                            int RateOfConversion = ord.Quantity / ord.DisplayQuantity;
                            AppSession.AddProductToCart(AppSession.CurrentOrders, curProduct, selectedItem.OrderPrice, selectedItem.DiscountType, selectedItem.DiscountValue, int.Parse(NewQty) * RateOfConversion, 0, string.Empty, false, curProduct.IsMiscellaneous, ord.DisplayQuantity, ord.DisplayName);
                        }
                        BindShoppingCart();
                    }
                }
            }
            else
            {
                App.ShowErrorMessageBox("Please select an item in the product cart", "Ei8ht POS");
            }
        }

        private void btnDiscount_Click(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentOrders != null && AppSession.CurrentOrders.OrdersDetailsList.Any())
            {
                string inputText, discountString, discountType;
                inputText = discountString = discountType = string.Empty;
                decimal discountValue = 0;

                inputText = UserPrompt.Prompt("Please enter discount value (ex: 10% for 10 percent discount or 10 for $10 dollar disc.)", "Discount Value"); //txtCommon.Text.Trim();
                if (inputText != null)
                {
                    discountString = inputText.Replace("%", string.Empty);

                    if (inputText.Contains("%"))
                    {
                        discountType = "Percentage";
                    }
                    else
                    {
                        discountType = "Dollar";
                    }
                    try
                    {
                        discountValue = decimal.Parse(discountString);
                    }
                    catch
                    {
                        App.ShowErrorMessageBox("Please enter valid Discount.", "Ei8ht POS");
                        return;
                    }

                    OrdersDetails selectedItem = lstShoppingCart.SelectedItem as OrdersDetails;
                    if (selectedItem == null)
                    {
                        selectedItem = AppSession.CurrentOrders.OrdersDetailsList.LastOrDefault<OrdersDetails>();
                    }
                    if (selectedItem != null)
                    {
                        Products curProduct = null;
                        if (!selectedItem.IsMiscellaneous)
                        {
                            curProduct = (from p in AppSession.ProductsList
                                          where p.UniqueID == selectedItem.ProductID
                                          select p).Single<Products>();
                        }
                        else
                        {
                            curProduct = AppSession.ProductsList.Where(p => p.IsMiscellaneous == true).FirstOrDefault();
                            curProduct.IsMiscellaneous = selectedItem.IsMiscellaneous;
                            curProduct.ProductName = selectedItem.ProductName;
                            curProduct.ProductDescriptions = selectedItem.Remarks;
                            curProduct.UnitPrice = selectedItem.OrderPrice;
                        }
                        decimal discount = 0;
                        if (discountType.Trim().ToLower().Equals("dollar"))
                        {
                            discount += (selectedItem.Quantity * discountValue);
                        }
                        else if (discountType.Trim().ToLower().Equals("percentage"))
                        {
                            discount += (selectedItem.Quantity * (selectedItem.OrderPrice * discountValue / 100));
                        }
                        if (discount <= (selectedItem.Quantity * selectedItem.OrderPrice))
                        {
                            AppSession.AddProductToCart(AppSession.CurrentOrders, curProduct, selectedItem.OrderPrice, discountType, discountValue, selectedItem.Quantity, 0, string.Empty, false, curProduct.IsMiscellaneous, 0);
                            BindShoppingCart();
                        }
                        else
                        {
                            App.ShowErrorMessageBox("Discount amount exceeds the Item total", "Ei8ht POS");
                        }

                    }
                    else
                    {
                        App.ShowErrorMessageBox("Please add any Item to the cart to apply the Discount.", "Ei8ht POS");
                    }
                }
            }
        }

        private void btnShowAll_Click(object sender, RoutedEventArgs e)
        {
            LoadProducts(string.Empty);
        }

        private void btnAddOpenItem_Click(object sender, RoutedEventArgs e)
        {
            AddMiscellaneousItem();
        }

        private void btnAddCustomer_Click(object sender, RoutedEventArgs e)
        {
            Controls.AddCustomerInfo addCust = new Controls.AddCustomerInfo();
            //addCust.Owner = MasterWindow;
            addCust.ShowInTaskbar = false;
            addCust.ShowDialog();
        }
        /// <summary>
        /// Send True to set discount. False to reset discount
        /// </summary>
        /// <param name="SetDiscount"></param>
        private void SetResetDiscount(bool SetDiscount)
        {
            if (AppSession.CurrentOrders != null && AppSession.CurrentOrders.OrdersDetailsList.Any())
            {
                string inputText, discountString, discountType;
                inputText = discountString = discountType = string.Empty;
                decimal discountValue = 0;
                if (SetDiscount)
                    inputText = UserPrompt.Prompt("Please enter Transaction Discount value.", "Discount Value");
                else
                    inputText = "0.00";
                if (inputText != null)
                {
                    discountString = inputText.Replace("%", string.Empty);

                    if (inputText.Contains("%"))
                    {
                        discountType = "Percentage";
                    }
                    else
                    {
                        discountType = "Dollar";
                    }
                    try
                    {
                        discountValue = decimal.Parse(discountString);
                    }
                    catch
                    {
                        App.ShowErrorMessageBox("Please enter valid Discount.", "Ei8ht POS");
                        return;
                    }

                    AppSession.CurrentOrders.DiscountType = discountType;
                    AppSession.CurrentOrders.DiscountValue = discountValue;
                    BindShoppingCart();
                    if (SetDiscount)
                        btnApplyTrxDiscount.Content = "Remove Discount";
                    else
                        btnApplyTrxDiscount.Content = "Overall Discount";
                }
            }
            else
            {
                App.ShowErrorMessageBox("Please add any Item to the cart to apply the Discount.", "Ei8ht POS");
            }
        }

        private void btnApplyTrxDiscount_Click(object sender, RoutedEventArgs e)
        {

            if (btnApplyTrxDiscount.Content.ToString().ToLower().Equals("overall discount"))
            {
                SetResetDiscount(true);
            }
            else
            {
                SetResetDiscount(false);
            }
        }

        private void btnPrintToKitchen_Click(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentOrders != null && AppSession.CurrentOrders.OrdersDetailsList.Count > 0)
            {
                string Remarks = SendToKitchen.Prompt("Please enter the table number and any remarks to the chef about the order", "Remarks");
                if (Remarks != null)
                {
                    Helper.ReceiptPrintHelper Printer = new Helper.ReceiptPrintHelper();
                    Printer.PrintToKitchen(AppSession.CurrentOrders, Remarks);
                }
            }
        }

        private void btnHappyHourDiscount_Click(object sender, RoutedEventArgs e)
        {
            string inputText, discountString, discountType;
            inputText = discountString = discountType = string.Empty;
            decimal discountValue = 0;

            inputText = UserPrompt.Prompt("Please enter Happy Hours Discount value.", "Discount Value");
            discountString = inputText.Replace("%", string.Empty);

            if (inputText.Contains("%"))
            {
                discountType = "Percentage";
            }
            else
            {
                discountType = "Dollar";
            }
            try
            {
                discountValue = decimal.Parse(discountString);
            }
            catch
            {
                App.ShowErrorMessageBox("Please enter valid Discount.", "Ei8ht POS");
                return;
            }

            decimal discount = 0;
            if (discountType.Trim().ToLower().Equals("dollar"))
            {
                discount = discountValue;
            }
            else if (discountType.Trim().ToLower().Equals("percentage"))
            {
                discount = AppSession.CurrentOrders.SubTotal * discountValue / 100;
            }
            if (discount < AppSession.CurrentOrders.SubTotal)
            {
                AppSession.CurrentOrders.HappyHoursDiscount = discount;
                BindShoppingCart();
            }
            else
            {
                App.ShowErrorMessageBox("Happy Hour Discount amount exceeds the Bill Amount", "Ei8ht POS");
            }
        }

        private void btnCategory_Click(object sender, RoutedEventArgs e)
        {
            Button SelectedCategory = sender as Button;
            Guid CategoryID = SelectedCategory.Tag != null ? Guid.Parse(SelectedCategory.Tag.ToString()) : Guid.Empty;
            LoadCategory(CategoryID);
        }

        private void btnSelectTable_Click(object sender, RoutedEventArgs e)
        {
            //ShowTableSelection();
        }

        private void ShowTableSelection()
        {
            Controls.CustomizeTableLayout pgeConfirm = new Controls.CustomizeTableLayout();
            pgeConfirm.Owner = Application.Current.MainWindow;
            pgeConfirm.ShowInTaskbar = false;
            pgeConfirm.ShowDialog();
            BindShoppingCart();
        }

        private void btnChangePrice_Click(object sender, RoutedEventArgs e)
        {
            //Load the dialog with actual price
            //If Item discount is applied then, Check if price change is applicable.
            //Update cart values

            OrdersDetails selectedItem = lstShoppingCart.SelectedItem as OrdersDetails;
            if (selectedItem == null)
            {
                selectedItem = AppSession.CurrentOrders.OrdersDetailsList.LastOrDefault<OrdersDetails>();
            }

            if (selectedItem != null)
            {
                string NewPrice = UserPrompt.Prompt("Please enter the new Price for " + selectedItem.ProductName, "Price Change");
                if (NewPrice != null)
                {
                    if (!ValidationUtility.ValidateDecimal(NewPrice))
                    {
                        App.ShowErrorMessageBox("Please enter valid Price.", "Ei8ht POS");
                        return;
                    }
                    else
                    {
                        selectedItem.OrderPrice = decimal.Parse(NewPrice);
                    }

                    Products curProduct = null;
                    if (!selectedItem.IsMiscellaneous)
                    {
                        curProduct = (from p in AppSession.ProductsList
                                      where p.UniqueID == selectedItem.ProductID
                                      select p).Single<Products>();
                    }
                    else
                    {
                        curProduct = AppSession.ProductsList.Where(p => p.IsMiscellaneous == true).FirstOrDefault();
                        curProduct.IsMiscellaneous = selectedItem.IsMiscellaneous;
                        curProduct.ProductName = selectedItem.ProductName;
                        curProduct.ProductDescriptions = selectedItem.Remarks;
                        curProduct.UnitPrice = selectedItem.OrderPrice;
                    }
                    AppSession.AddProductToCart(AppSession.CurrentOrders, curProduct, selectedItem.OrderPrice, selectedItem.DiscountType, selectedItem.DiscountValue, selectedItem.Quantity, 0, string.Empty, false, curProduct.IsMiscellaneous, 0);
                    BindShoppingCart();
                }
            }
            else
            {
                App.ShowErrorMessageBox("Please select an item in the product cart", "Ei8ht POS");
            }
        }

        private void btnApplyGST_Click(object sender, RoutedEventArgs e)
        {
            GstApplied = true;
            BindShoppingCart();
        }

        private void btnRemoveGST_Click(object sender, RoutedEventArgs e)
        {
            GstApplied = false;
            BindShoppingCart();
        }

        #endregion

        #region Discount, Service Charge, Promotion

        private void ApplyTxnDiscount()
        {
            if (!AppSession.CurrentOrders.OrdersDetailsList.Any())
            {
                AppSession.CurrentOrders.TotalDiscount = AppSession.CurrentOrders.DiscountValue = 0;
                AppSession.CurrentOrders.DiscountType = string.Empty;
                return;
            }

            decimal discount = 0;
            if (!string.IsNullOrEmpty(AppSession.CurrentOrders.DiscountType))
            {
                if (AppSession.CurrentOrders.DiscountType.Trim().ToLower().Equals("dollar"))
                {
                    discount = AppSession.CurrentOrders.DiscountValue;
                }
                else if (AppSession.CurrentOrders.DiscountType.Trim().ToLower().Equals("percentage"))
                {
                    discount = Math.Round(AppSession.CurrentOrders.OrdersDetailsList.Where(x => x.CanApplyDiscount).Sum(d => d.Amount) * AppSession.CurrentOrders.DiscountValue / 100, 2);
                }
                if (discount <= AppSession.CurrentOrders.SubTotal + AppSession.CurrentOrders.Discount)
                {
                    AppSession.CurrentOrders.TotalDiscount = discount;
                }
                else
                {
                    App.ShowErrorMessageBox("Total Discount amount exceeds the Bill Amount", "Ei8ht POS");
                    AppSession.CurrentOrders.TotalDiscount = AppSession.CurrentOrders.DiscountValue = 0;
                    AppSession.CurrentOrders.DiscountType = string.Empty;
                }
            }
        }

        private void ApplyServiceTax()
        {

            if (!AppSession.CurrentOrders.OrdersDetailsList.Any())
            {
                AppSession.CurrentOrders.ServiceTax = 0;
                AppSession.CurrentOrders.ServiceTaxValue = AppSession.ServiceTaxPercent;
                AppSession.CurrentOrders.ServiceTaxType = "percentage";
                return;
            }

            decimal serviceTax = 0;

            if (!string.IsNullOrEmpty(AppSession.CurrentOrders.ServiceTaxType))
            {
                if (AppSession.CurrentOrders.ServiceTaxType.Trim().ToLower().Equals("dollar"))
                {
                    serviceTax = AppSession.CurrentOrders.ServiceTaxValue;
                }
                else if (AppSession.CurrentOrders.ServiceTaxType.Trim().ToLower().Equals("percentage"))
                {
                    serviceTax = Math.Round((AppSession.CurrentOrders.SubTotal - AppSession.CurrentOrders.HappyHoursDiscount - AppSession.CurrentOrders.TotalDiscount - AppSession.CurrentOrders.Discount) * AppSession.CurrentOrders.ServiceTaxValue / 100, 2);
                }
                if (serviceTax <= AppSession.CurrentOrders.SubTotal + AppSession.CurrentOrders.Discount)
                {
                    AppSession.CurrentOrders.ServiceTax = serviceTax;
                }
                else
                {
                    App.ShowErrorMessageBox("Service Charge exceeds the Bill Amount", "Ei8ht POS");
                    AppSession.CurrentOrders.ServiceTax = AppSession.CurrentOrders.ServiceTaxValue = 0;
                    AppSession.CurrentOrders.ServiceTaxType = string.Empty;
                }
            }
        }

        private void ApplyPromotion()
        {
            foreach (OrdersDetails od in AppSession.CurrentOrders.OrdersDetailsList)
            {
                bool applyPromo = false;
                Promotion currentPromo = AppSession.PromotionList.Where(x => x.PromotionDetailsList.Any(y => y.ProductsID == od.ProductID)).FirstOrDefault();

                if (currentPromo != null)
                {
                    PromotionDetails currentPromoDetail = currentPromo.PromotionDetailsList.Where(y => y.ProductsID == od.ProductID).FirstOrDefault();
                    if (currentPromoDetail != null)
                    {
                        if (currentPromoDetail.PromoType.Equals("Quantity"))
                        {
                            if (currentPromo.OrderTotalFrom != 0)
                            {
                                if (currentPromo.OrderTotalTo != 0)
                                {
                                    if (AppSession.CurrentOrders.TotalBeforeGST >= currentPromo.OrderTotalFrom && AppSession.CurrentOrders.TotalBeforeGST <= currentPromo.OrderTotalTo)
                                    {
                                        applyPromo = true;
                                    }
                                }
                                else if (currentPromo.UseFromPrice)
                                {
                                    if (AppSession.CurrentOrders.TotalBeforeGST >= currentPromo.OrderTotalFrom)
                                    {
                                        applyPromo = true;
                                    }
                                }
                                else
                                {
                                    applyPromo = false;
                                }
                            }
                            else
                            {
                                applyPromo = true;
                            }

                            if (applyPromo)
                            {
                                if (od.Quantity >= currentPromoDetail.BuyingQty)
                                {
                                    int diff = od.Quantity / currentPromoDetail.BuyingQty;
                                    int discountQty = diff * currentPromoDetail.DiscountQty;
                                    od.DiscountQuantity = discountQty;
                                }
                            }
                        }
                        else if (currentPromoDetail.PromoType.Equals("Dollar"))
                        {

                        }
                        else if (currentPromoDetail.PromoType.Equals("Percentage"))
                        {

                        }
                    }
                }
            }
        }

        private void ApplyGST(bool isRemove)
        {
            if (!isRemove)
            {
                AppSession.CurrentOrders.GST = Math.Round((AppSession.CurrentOrders.TotalBeforeGST * AppSession.GSTPercent / 100), 2);
            }
            else
            {
                AppSession.CurrentOrders.GST = 0;
            }
        }

        private void icProductList_Loaded(object sender, RoutedEventArgs e)
        {
            if (AppSession.CurrentOrders == null)
            {
                PoleDisplayHelper.ClearDisplay();
                //ShowTableSelection();
            }
            else
            {
                if (string.IsNullOrEmpty(AppSession.CurrentOrders.TableNumber))
                {
                    PoleDisplayHelper.ClearDisplay();
                    //ShowTableSelection();
                }
            }
        }

        #endregion

        private void btnPendingOrders_Click_1(object sender, RoutedEventArgs e)
        {
            Admin obj = new Admin();
            Master.LoadPages(obj, Menus.ADMIN);
            obj.OpenPendingTransaction();
        }
    }
}